#[test]
fn random_colors() {
    // The color string is randomly generated, then parsed using Chromium 87.0.4280.66
    let test_data = [
        ("#9F2", [153, 255, 34, 255]),
        ("#919211", [145, 146, 17, 255]),
        ("#DF1A94", [223, 26, 148, 255]),
        ("#0E9665", [14, 150, 101, 255]),
        ("#D39", [221, 51, 153, 255]),
        ("#6EF1BB", [110, 241, 187, 255]),
        ("#5F2452", [95, 36, 82, 255]),
        ("#8E6", [136, 238, 102, 255]),
        ("#09BB", [0, 153, 187, 187]),
        ("#A51", [170, 85, 17, 255]),
        ("#E1FCF3", [225, 252, 243, 255]),
        ("#02E3", [0, 34, 238, 51]),
        ("#E6B2", [238, 102, 187, 34]),
        ("#8CEA3820", [140, 234, 56, 32]),
        ("#2B8", [34, 187, 136, 255]),
        ("#195", [17, 153, 85, 255]),
        ("#4B6", [68, 187, 102, 255]),
        ("#9AE", [153, 170, 238, 255]),
        ("#9D39E0", [157, 57, 224, 255]),
        ("#66E12CAC", [102, 225, 44, 172]),
        ("#27EB", [34, 119, 238, 187]),
        ("#9C12", [153, 204, 17, 34]),
        ("#86113903", [134, 17, 57, 3]),
        ("#B1C6ED", [177, 198, 237, 255]),
        ("#79D", [119, 153, 221, 255]),
        ("#D3F8B137", [211, 248, 177, 55]),
        ("#E2858DF2", [226, 133, 141, 242]),
        ("#B0DBA6", [176, 219, 166, 255]),
        ("#F7F", [255, 119, 255, 255]),
        ("#97C9", [153, 119, 204, 153]),
        ("#F06", [255, 0, 102, 255]),
        ("#243B", [34, 68, 51, 187]),
        ("#20DA", [34, 0, 221, 170]),
        ("#13C364B8", [19, 195, 100, 184]),
        ("#E515", [238, 85, 17, 85]),
        ("#A11C", [170, 17, 17, 204]),
        ("#488", [68, 136, 136, 255]),
        ("#5EE", [85, 238, 238, 255]),
        ("#5AB8A1", [90, 184, 161, 255]),
        ("#9A9AB8", [154, 154, 184, 255]),
        ("#EA9E", [238, 170, 153, 238]),
        ("#551AB14D", [85, 26, 177, 77]),
        ("#D1D5", [221, 17, 221, 85]),
        ("#3C4", [51, 204, 68, 255]),
        ("#B615FED3", [182, 21, 254, 211]),
        ("#FC7", [255, 204, 119, 255]),
        ("#4B10D2", [75, 16, 210, 255]),
        ("#2188EC", [33, 136, 236, 255]),
        ("#A68F5F9F", [166, 143, 95, 159]),
        ("#4670E4", [70, 112, 228, 255]),
        ("rgb(56.467,186.479,125.521)", [56, 186, 126, 255]),
        ("rgb(227.181,102.976,142.108)", [227, 103, 142, 255]),
        ("rgb(30.436,119.528,76.579)", [30, 120, 77, 255]),
        ("rgb(93.103,251.965,52.385)", [93, 252, 52, 255]),
        ("rgb(161.891,261.654,114.275)", [162, 255, 114, 255]),
        ("rgb(235.921,88.153,244.002)", [236, 88, 244, 255]),
        ("rgb(185.204,3.571,140.660,1.079)", [185, 4, 141, 255]),
        ("rgb(141.230,184.483,37.035)", [141, 184, 37, 255]),
        ("rgb(37.685,82.003,192.789,0.283)", [38, 82, 193, 72]),
        ("rgb(45.740,9.845,259.876)", [46, 10, 255, 255]),
        ("rgb(86.411,188.879,237.442,0.876)", [86, 189, 237, 223]),
        ("rgb(156.438,191.727,52.916)", [156, 192, 53, 255]),
        ("rgb(216.423,5.520,180.029,0.589)", [216, 6, 180, 150]),
        ("rgb(92.120,247.582,38.473)", [92, 248, 38, 255]),
        ("rgb(191.287,191.154,217.583)", [191, 191, 218, 255]),
        ("rgb(12.653,152.639,193.900)", [13, 153, 194, 255]),
        ("rgb(202.973,184.215,144.797)", [203, 184, 145, 255]),
        ("rgb(136.571,182.362,162.541,0.148)", [137, 182, 163, 38]),
        ("rgb(242.371,-9.883,94.380)", [242, 0, 94, 255]),
        ("rgb(225.423,48.220,245.090,0.771)", [225, 48, 245, 197]),
        ("rgb(120.844,198.795,84.888)", [121, 199, 85, 255]),
        ("rgb(164.768,213.433,79.101,0.592)", [165, 213, 79, 151]),
        ("rgb(38.678,179.795,181.240,0.668)", [39, 180, 181, 170]),
        ("rgb(20.568,-4.233,125.669)", [21, 0, 126, 255]),
        ("rgb(16.521,145.769,228.928,1.141)", [17, 146, 229, 255]),
        ("rgb(167.249,179.288,124.859,0.518)", [167, 179, 125, 132]),
        ("rgb(89.103,46.835,144.170)", [89, 47, 144, 255]),
        ("rgb(135.687,86.916,220.479,0.668)", [136, 87, 220, 170]),
        ("rgb(162.398,-6.010,110.044,0.753)", [162, 0, 110, 192]),
        ("rgb(232.790,116.598,58.135)", [233, 117, 58, 255]),
        ("rgb(151.480,198.087,129.953,0.205)", [151, 198, 130, 52]),
        ("rgb(220.157,183.680,73.321)", [220, 184, 73, 255]),
        ("rgb(182.469,204.897,82.469,0.901)", [182, 205, 82, 230]),
        ("rgb(4.167,34.557,42.727,0.701)", [4, 35, 43, 179]),
        ("rgb(43.038,100.728,14.607,1.052)", [43, 101, 15, 255]),
        ("rgb(0.045,150.822,2.053)", [0, 151, 2, 255]),
        ("rgb(252.789,220.105,226.842)", [253, 220, 227, 255]),
        ("rgb(158.071,262.551,21.134,1.191)", [158, 255, 21, 255]),
        ("rgb(233.762,23.326,169.395)", [234, 23, 169, 255]),
        ("rgb(231.402,104.070,-9.010,1.065)", [231, 104, 0, 255]),
        ("rgb(179.325,103.168,150.187,0.284)", [179, 103, 150, 72]),
        ("rgb(139.902,99.310,145.976)", [140, 99, 146, 255]),
        ("rgb(50.983,172.151,210.545,0.455)", [51, 172, 211, 116]),
        ("rgb(17.199,167.421,194.514,0.667)", [17, 167, 195, 170]),
        ("rgb(66.992,32.529,37.688,0.161)", [67, 33, 38, 41]),
        ("rgb(224.304,84.063,222.623)", [224, 84, 223, 255]),
        ("rgb(203.817,45.691,5.316)", [204, 46, 5, 255]),
        ("rgb(154.775,257.630,253.717)", [155, 255, 254, 255]),
        ("rgb(113.736,190.662,180.949)", [114, 191, 181, 255]),
        ("rgb(198.089,-9.253,145.769)", [198, 0, 146, 255]),
        ("rgb(36.705%,17.074%,105.740%,-0.093)", [94, 44, 255, 0]),
        ("rgb(36.517%,9.269%,20.384%,-0.136)", [93, 24, 52, 0]),
        ("rgb(43.466%,65.604%,55.038%)", [111, 167, 140, 255]),
        ("rgb(48.285%,63.684%,56.161%)", [123, 162, 143, 255]),
        ("rgb(-4.882%,-3.380%,43.553%)", [0, 0, 111, 255]),
        ("rgb(27.307%,75.448%,88.504%)", [70, 192, 226, 255]),
        ("rgb(69.694%,59.503%,75.063%)", [178, 152, 191, 255]),
        ("rgb(90.960%,12.457%,12.447%)", [232, 32, 32, 255]),
        ("rgb(-4.622%,36.627%,-8.178%)", [0, 93, 0, 255]),
        ("rgb(87.787%,20.447%,43.423%)", [224, 52, 111, 255]),
        ("rgb(67.308%,86.285%,72.392%,0.038)", [172, 220, 185, 10]),
        ("rgb(103.478%,75.442%,82.578%,0.746)", [255, 192, 211, 190]),
        ("rgb(94.011%,90.970%,79.718%)", [240, 232, 203, 255]),
        ("rgb(101.439%,74.849%,45.099%)", [255, 191, 115, 255]),
        ("rgb(89.327%,31.033%,44.547%)", [228, 79, 114, 255]),
        ("rgb(14.834%,42.672%,105.987%,0.244)", [38, 109, 255, 62]),
        ("rgb(21.958%,36.904%,78.661%)", [56, 94, 201, 255]),
        ("rgb(-6.690%,87.366%,71.478%)", [0, 223, 182, 255]),
        ("rgb(28.576%,39.953%,66.600%)", [73, 102, 170, 255]),
        ("rgb(40.806%,108.938%,47.153%,1.186)", [104, 255, 120, 255]),
        ("rgb(56.260%,70.797%,1.857%)", [143, 181, 5, 255]),
        ("rgb(83.108%,-8.247%,-6.553%,0.081)", [212, 0, 0, 21]),
        ("rgb(74.833%,49.474%,93.795%,0.274)", [191, 126, 239, 70]),
        ("rgb(68.953%,0.784%,100.538%,0.815)", [176, 2, 255, 208]),
        ("rgb(82.811%,4.286%,-7.748%)", [211, 11, 0, 255]),
        ("rgb(60.598%,108.140%,92.018%)", [155, 255, 235, 255]),
        ("rgb(43.708%,17.419%,-0.824%)", [111, 44, 0, 255]),
        ("rgb(25.794%,80.139%,104.639%)", [66, 204, 255, 255]),
        ("rgb(38.556%,11.224%,-1.615%)", [98, 29, 0, 255]),
        ("rgb(16.455%,48.941%,54.732%,0.187)", [42, 125, 140, 48]),
        ("rgb(80.390%,-9.653%,33.214%)", [205, 0, 85, 255]),
        ("rgb(79.032%,-1.482%,102.516%)", [202, 0, 255, 255]),
        ("rgb(84.366%,31.407%,87.727%)", [215, 80, 224, 255]),
        ("rgb(75.236%,101.526%,15.918%)", [192, 255, 41, 255]),
        ("rgb(41.238%,3.048%,1.219%)", [105, 8, 3, 255]),
        ("rgb(100.594%,5.613%,69.223%,0.190)", [255, 14, 177, 48]),
        ("rgb(50.523%,91.169%,-9.786%,-0.006)", [129, 232, 0, 0]),
        ("rgb(64.531%,35.250%,34.396%,0.566)", [165, 90, 88, 144]),
        ("rgb(29.348%,73.790%,37.770%)", [75, 188, 96, 255]),
        ("rgb(33.014%,25.582%,90.210%)", [84, 65, 230, 255]),
        ("rgb(-5.318%,-3.605%,13.564%)", [0, 0, 35, 255]),
        ("rgb(29.700%,52.430%,-9.889%)", [76, 134, 0, 255]),
        ("rgb(11.953%,5.255%,59.970%)", [30, 13, 153, 255]),
        ("rgb(76.719%,30.732%,61.515%,0.289)", [196, 78, 157, 74]),
        ("rgb(100.532%,96.866%,9.823%,0.475)", [255, 247, 25, 121]),
        ("rgb(25.194%,36.877%,67.434%,0.940)", [64, 94, 172, 240]),
        ("rgb(6.368%,90.828%,14.714%,0.304)", [16, 232, 38, 78]),
        ("rgb(90.081%,-4.819%,37.658%)", [230, 0, 96, 255]),
        ("rgb(-1.297%,9.539%,70.162%)", [0, 24, 179, 255]),
        ("rgb(47.324%,8.645%,-0.478%)", [121, 22, 0, 255]),
        ("hsl(0.069turn,21.307%,-3.478%,1.007)", [0, 0, 0, 255]),
        ("hsl(72.142,4.735%,-7.464%,1.042)", [0, 0, 0, 255]),
        ("hsl(0.890turn,49.391%,38.567%)", [147, 50, 114, 255]),
        ("hsl(3.845grad,68.172%,-6.573%)", [0, 0, 0, 255]),
        ("hsl(193.837,21.934%,21.649%)", [43, 62, 67, 255]),
        ("hsl(162.965deg,6.690%,44.810%)", [107, 122, 118, 255]),
        ("hsl(0.468turn,100.941%,37.582%)", [0, 192, 155, 255]),
        ("hsl(0.058turn,51.911%,48.034%,-0.122)", [186, 103, 59, 0]),
        ("hsl(120.939,66.051%,77.958%,0.145)", [162, 236, 163, 37]),
        ("hsl(72.452deg,63.319%,84.331%)", [230, 240, 190, 255]),
        ("hsl(155.120grad,106.379%,58.737%)", [45, 255, 113, 255]),
        ("hsl(5.240rad,-4.171%,32.487%)", [83, 83, 83, 255]),
        ("hsl(4.565rad,-3.467%,20.547%)", [52, 52, 52, 255]),
        ("hsl(295.291,7.475%,3.742%)", [10, 9, 10, 255]),
        ("hsl(4.287rad,96.686%,41.460%,1.012)", [23, 4, 208, 255]),
        ("hsl(0.283turn,95.539%,97.779%,1.064)", [247, 255, 244, 255]),
        ("hsl(2.638rad,37.279%,-9.931%)", [0, 0, 0, 255]),
        ("hsl(0.295turn,21.487%,35.668%,0.217)", [80, 110, 71, 55]),
        ("hsl(60.183deg,41.823%,22.086%)", [80, 80, 33, 255]),
        ("hsl(-0.021rad,64.948%,7.915%)", [33, 7, 8, 255]),
        ("hsl(121.677deg,15.914%,19.922%,-0.019)", [43, 59, 43, 0]),
        ("hsl(2.829rad,-9.457%,77.556%,-0.068)", [198, 198, 198, 0]),
        ("hsl(259.505grad,93.623%,67.416%)", [94, 111, 250, 255]),
        ("hsl(0.404rad,-4.398%,104.641%)", [255, 255, 255, 255]),
        ("hsl(0.840turn,76.343%,94.714%,0.063)", [252, 231, 251, 16]),
        ("hsl(49.836grad,83.982%,3.411%)", [16, 12, 1, 255]),
        ("hsl(0.018turn,107.944%,20.884%)", [107, 12, 0, 255]),
        ("hsl(0.375turn,22.837%,73.947%)", [173, 204, 181, 255]),
        ("hsl(331.324deg,84.224%,61.278%,0.830)", [239, 73, 153, 212]),
        ("hsl(2.062rad,60.636%,71.565%)", [141, 226, 139, 255]),
        ("hsl(91.718grad,48.490%,44.280%)", [127, 168, 58, 255]),
        (
            "hsl(255.829deg,62.751%,107.894%,-0.045)",
            [255, 255, 255, 0],
        ),
        ("hsl(98.567grad,-6.159%,27.281%)", [70, 70, 70, 255]),
        ("hsl(1.517rad,83.487%,29.247%)", [81, 137, 12, 255]),
        ("hsl(83.494deg,99.500%,61.584%)", [178, 255, 60, 255]),
        ("hsl(400.564grad,42.181%,-6.001%,1.145)", [0, 0, 0, 255]),
        ("hsl(334.198deg,80.826%,90.951%,0.042)", [251, 213, 229, 11]),
        ("hsl(154.176,15.036%,62.757%,0.815)", [146, 174, 162, 208]),
        ("hsl(0.029rad,57.145%,72.419%)", [225, 147, 144, 255]),
        ("hsl(266.629,25.394%,-1.463%,0.584)", [0, 0, 0, 149]),
        ("hsl(5.873rad,105.561%,14.063%)", [72, 0, 28, 255]),
        ("hsl(5.731rad,38.296%,105.210%,0.659)", [255, 255, 255, 168]),
        ("hsl(327.273,65.108%,71.932%)", [230, 137, 188, 255]),
        ("hsl(89.405,36.983%,94.707%)", [242, 246, 237, 255]),
        ("hsl(0.925turn,78.035%,97.489%)", [254, 244, 248, 255]),
        ("hsl(0.000turn,56.799%,105.320%)", [255, 255, 255, 255]),
        ("hsl(2.276rad,107.756%,74.291%,0.290)", [124, 255, 147, 74]),
        ("hsl(215.619,25.313%,100.025%,-0.116)", [255, 255, 255, 0]),
        ("hsl(41.239,30.040%,7.348%)", [24, 21, 13, 255]),
        ("hsl(5.794rad,109.895%,71.423%)", [255, 109, 177, 255]),
    ];
    for (s, expected) in test_data {
        let rgba = csscolorparser::parse(s).unwrap().to_rgba8();
        assert_eq!(expected, rgba);
    }
}
