
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotVisualiserAttributes.h
    \\brief Definition of BoxPlotVisualiser Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "BoxPlotVisualiserWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



BoxPlotVisualiserWrapper::BoxPlotVisualiserWrapper(): boxplotvisualiser_(new BoxPlotVisualiser())


{


	

}
BoxPlotVisualiserWrapper::BoxPlotVisualiserWrapper(BoxPlotVisualiser* boxplotvisualiser): boxplotvisualiser_(boxplotvisualiser)
{

	
}

BoxPlotVisualiserWrapper::~BoxPlotVisualiserWrapper()
{

}

void BoxPlotVisualiserWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("BOXPLOT_BOX") ) {
		string box_value = request("BOXPLOT_BOX");
		
		boxplotvisualiser_->box_ = MagTranslator<string, bool>()(box_value);
		
		}
	if  (request.countValues("BOXPLOT_BOX_WIDTH") ) {
		double box_width_value = request("BOXPLOT_BOX_WIDTH");
		boxplotvisualiser_->box_width_ = box_width_value;
		}
	if  (request.countValues("BOXPLOT_BOX_BORDER") ) {
		string box_border_value = request("BOXPLOT_BOX_BORDER");
		
		boxplotvisualiser_->box_border_ = MagTranslator<string, bool>()(box_border_value);
		
		}
	if  (request.countValues("BOXPLOT_BOX_BORDER_THICKNESS") ) {
		int box_border_thickness_value = request("BOXPLOT_BOX_BORDER_THICKNESS");
		boxplotvisualiser_->box_border_thickness_ = box_border_thickness_value;
		}
	if  (request.countValues("BOXPLOT_MEDIAN") ) {
		string median_value = request("BOXPLOT_MEDIAN");
		
		boxplotvisualiser_->median_ = MagTranslator<string, bool>()(median_value);
		
		}
	if  (request.countValues("BOXPLOT_MEDIAN_THICKNESS") ) {
		int median_thickness_value = request("BOXPLOT_MEDIAN_THICKNESS");
		boxplotvisualiser_->median_thickness_ = median_thickness_value;
		}
	if  (request.countValues("BOXPLOT_WHISKER") ) {
		string whisker_value = request("BOXPLOT_WHISKER");
		boxplotvisualiser_->whisker_ = whisker_value;
		}
	if  (request.countValues("BOXPLOT_WHISKER_BOX_WIDTH") ) {
		double whisker_box_width_value = request("BOXPLOT_WHISKER_BOX_WIDTH");
		boxplotvisualiser_->whisker_box_width_ = whisker_box_width_value;
		}
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER") ) {
		string whisker_box_border_value = request("BOXPLOT_WHISKER_BOX_BORDER");
		
		boxplotvisualiser_->whisker_box_border_ = MagTranslator<string, bool>()(whisker_box_border_value);
		
		}
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_THICKNESS") ) {
		int whisker_box_border_thickness_value = request("BOXPLOT_WHISKER_BOX_BORDER_THICKNESS");
		boxplotvisualiser_->whisker_box_border_thickness_ = whisker_box_border_thickness_value;
		}
	if  (request.countValues("BOXPLOT_WHISKER_LINE_THICKNESS") ) {
		int whisker_line_thickness_value = request("BOXPLOT_WHISKER_LINE_THICKNESS");
		boxplotvisualiser_->whisker_line_thickness_ = whisker_line_thickness_value;
		}
	
	if  (request.countValues("BOXPLOT_BOX_COLOUR") ) {
		string box_colour_value = request("BOXPLOT_BOX_COLOUR");
		boxplotvisualiser_->box_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(box_colour_value));
	}
		
	if  (request.countValues("BOXPLOT_BOX_BORDER_COLOUR") ) {
		string box_border_colour_value = request("BOXPLOT_BOX_BORDER_COLOUR");
		boxplotvisualiser_->box_border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(box_border_colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_BOX_BORDER_LINE_STYLE") ) {
		string box_border_style_value = request("BOXPLOT_BOX_BORDER_LINE_STYLE");
		boxplotvisualiser_->box_border_style_ = MagTranslator<string, LineStyle>()(box_border_style_value);
	}
		
	if  (request.countValues("BOXPLOT_MEDIAN_COLOUR") ) {
		string median_colour_value = request("BOXPLOT_MEDIAN_COLOUR");
		boxplotvisualiser_->median_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(median_colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_MEDIAN_LINE_STYLE") ) {
		string median_style_value = request("BOXPLOT_MEDIAN_LINE_STYLE");
		boxplotvisualiser_->median_style_ = MagTranslator<string, LineStyle>()(median_style_value);
	}
		
	if  (request.countValues("BOXPLOT_WHISKER_BOX_COLOUR") ) {
		string whisker_box_colour_value = request("BOXPLOT_WHISKER_BOX_COLOUR");
		boxplotvisualiser_->whisker_box_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(whisker_box_colour_value));
	}
		
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_COLOUR") ) {
		string whisker_box_border_colour_value = request("BOXPLOT_WHISKER_BOX_BORDER_COLOUR");
		boxplotvisualiser_->whisker_box_border_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(whisker_box_border_colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_WHISKER_BOX_BORDER_LINE_STYLE") ) {
		string whisker_box_border_style_value = request("BOXPLOT_WHISKER_BOX_BORDER_LINE_STYLE");
		boxplotvisualiser_->whisker_box_border_style_ = MagTranslator<string, LineStyle>()(whisker_box_border_style_value);
	}
		
	if  (request.countValues("BOXPLOT_WHISKER_LINE_COLOUR") ) {
		string whisker_line_colour_value = request("BOXPLOT_WHISKER_LINE_COLOUR");
		boxplotvisualiser_->whisker_line_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(whisker_line_colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_WHISKER_LINE_STYLE") ) {
		string whisker_line_style_value = request("BOXPLOT_WHISKER_LINE_STYLE");
		boxplotvisualiser_->whisker_line_style_ = MagTranslator<string, LineStyle>()(whisker_line_style_value);
	}
		
	
}

void BoxPlotVisualiserWrapper::print(ostream& out)  const
{
	out << "BoxPlotVisualiserWrapper[]";
}












