---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, graphiques, statistiques,
              TikZ, barplot, histogramme, tracer une fonction, mathématiques, 
              data science
---

# Comment inclure un graphique statistique ?

Imaginons que vous ayez un tableau de données, et que vous souhaitiez en faire
une représentation graphique dans votre document LaTeX. Pour cela, vous n'avez
besoin d'aucun logiciel externe. En dessinant votre graphique directement 
en LaTeX, vous aurez une intégration complète du texte et de la figure : 
police de caractères identique, taille de la figure qui s'adapte à la taille 
du texte, couleurs identiques (si besoin).

Notez que si vous avez déjà un graphique, obtenu à partir d'un autre logiciel
(R, MatLab, LibreOffice, Excel...), vous pouvez simplement l'inclure avec 
la commande suivante (le `width=10cm` étant bien entendu une option modifiable,
parmi d'autres) :

```{noedit}
\includegraphics[width=10cm]{fichier}
```

Dans ce cas, il est préférable que le graphique soit au format PDF, mais 
il est également possible d'inclure du PNG ou du JPEG. La question
"[](/3_composition/illustrations/images/inclure_une_image)"
vous donnera plus d'information.


## Avec l'extension <ctanpkg:PGFPlots>

L'extension <ctanpkg:PGFPlots> utilise [TikZ](ctanpkg:pgf) pour construire 
le dessin, tout en fournissant une syntaxe intuitive pour décrire le résultat
que vous voulez.

Elle propose un environnement `axis`, dont les paramètres modifient le style
de graphique.

Par défaut, les nombres sont affichés avec le point comme séparateur 
de décimal. Est proposé ici un exemple permettant de régler ce "problème", 
ainsi que les réglages principaux d’un graphique.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}
  \usepackage{xcolor}
  \usepackage{pgfplots}
  \usepackage{siunitx}
  \sisetup{locale = FR}

\begin{document}
\begin{tikzpicture}
  \begin{axis}[
    y tick label style = {%
      /pgf/number format/.cd,
      set thousands separator = {\,},
      set decimal separator = {,},
      fixed,
      /tikz/.cd
    },
    x tick label style = {
      /pgf/number format/.cd,
      set decimal separator = {,},
      set thousands separator = {\,},
      fixed,
      /tikz/.cd 
    },
    width = 1 \linewidth,
    height = 7.5cm,
    ymin = 0,
    xmin = 0,
    xlabel = $c/\unit{\mol\per\l}$,
    ylabel = $A$,
    grid = both,
    minor tick num = 4,
    tickpos = left,
    scaled ticks = true, % pour ajouter puisssance de 10 globale
    scaled x ticks = base 10:5,
    tick scale binop = \times, % avec le signe "x" au lieu du point
    domain = 0:6,
    minor grid style = {color = gray!25},
    major grid style = {color = gray},
    legend pos = north west,
    legend entries = {Points expérimentaux, $A=\num{2.1e3} \times c$},
    title= Courbe d’étalonnage,
    ]
    \addplot[only marks, red, mark=*] coordinates {
      (3e-5, 0.068)
      (4e-5, 0.073)
      (5e-5, 0.111)
      (6e-5, 0.115)
      (8e-5, 0.151)
      (10e-5, 0.249)
    };
    \addplot[blue, domain = 0:1.2e-4]{2.1e3*\x};
    % \legend()
  \end{axis}
\end{tikzpicture}
\end{document}
```

Si certains réglages sont communs à plusieurs graphiques du document 
(typiquement le réglage des nombres en "français"), vous pourrez les faire
dans le préambule à l’aide de la commande `pgfplotsset{}`.

```{noedit}
\pgfplotsset{compat = newest,
  y tick label style = {%
    /pgf/number format/.cd,
    set thousands separator = {\,},
    set decimal separator = {,},
    fixed,
    /tikz/.cd
  },
  x tick label style = {%
    /pgf/number format/.cd,
    set decimal separator = {,},
    set thousands separator = {\,}, %scaled ticks = base 10:3,
    fixed,
    /tikz/.cd % on se replace dans le bon dossier
  },
  minor grid style = {color = lightgray!30},
  major grid style = {color = lightgray},
  scaled ticks = true, % pour ajouter puisssance de 10 globale
  tick scale binop = \times, % avec le signe "x"
  tickpos = left,
}
```


## Avec l'extension <ctanpkg:TikZ> (mais sans <ctanpkg:PGFPlots>)

Si votre graphique est tellement particulier qu'il s'écarte de ce que sait
faire <ctanpkg:PGFPlots>, vous pouvez très bien utiliser directement 
l'extension <ctanpkg:TikZ>.

Ici, un exemple plutôt simple pour construire un repère avec des axes gradués :

```
% Un fichier de données créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{donnees.data}
6.3 9.5
7.4 7
8 14
13.1 22
14.7 23.1
11.8 15
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
\centering % pour centrer le graphique
\begin{tikzpicture}[scale=.5, only marks, y=.5cm]
  \draw plot[mark=*,xshift=-6cm] file {donnees.data};
  \draw[->,xshift=-6cm] (6,0) -- coordinate (x axis mid) (17,0);
  \draw[->,xshift=-6cm] (6,0) -- coordinate (y axis mid)(6,27);
  \foreach \x in {6,8,10,12,14,16}
    \draw [xshift=-6cm](\x cm,1pt) -- (\x cm,-3pt) node[anchor=north] {$\x$};
    \foreach \y/\ytext in {0/0,2.5/5000,5/10000,7.5/15000,10/20000,12.5/25000}
      \draw (1pt,\y cm) -- (-3pt,\y cm) node[anchor=east] {$\ytext$};
    \node[below=5mm] at (x axis mid) {Ancienneté};
    \node[left=15mm,rotate=90] at (y axis mid) {Salaire};
\end{tikzpicture}
\end{document}
```


## Avec l'extension <ctanpkg:PSTricks> et l'extension <ctanpkg:pst-plot>

L'extension <ctanpkg:PSTricks> propose ces propres solutions pour générer
des graphiques avec, en particulier, l'extension <ctanpkg:pst-plot>.

En voici un exemple, basé sur la [documentation](texdoc:pst-plot) 
de <ctanpkg:pst-plot>. Notez que nous utilisons ici le moteur LuaLaTeX, 
ce dernier étant directement compatible avec l'extension.

```
%!TEX engine=lualatex
% Un fichier de données créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{donnees.data}
1 950000
4 1700000
7 3650000
8 2200000
12 4300000
16 1500000
19 5650000
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pst-plot}

\begin{document}
\readdata{\data}{donnees.data}
\pstScalePoints(1,1e-06){}{}
\psset{llx=-1cm,lly=-1cm}
\begin{psgraph}[ticklinestyle=dashed, 
  xticksize=0 6, yticksize=0 20, ylabelFactor=\cdot 10^6,%
  Dx=5, dy=1\psyunit, Dy=1](0,0)(20,6){8cm}{6cm} % parameters
\listplot[linecolor=blue,linewidth=2pt,showpoints=true]{\data}
\end{psgraph}
\end{document}
``` 


:::{sources}
- [Les graphiques sous TikZ](https://blog.dorian-depriester.fr/latex/tikz/les-graphiques-sous-tikz),
  sur le [blog de Dorian Depriester](https://blog.dorian-depriester.fr/latex/)
- [Comment faire de beaux graphiques avec Tikz et PGFPLOTS](http://bertrandmasson.free.fr/index.php?article28/comment-faire-de-beaux-graphiques-avec-tikz-et-pgfplots),
  sur [Les fiches à Bébert](http://www.lesfichesabebert.fr/)
- [Plots examples](https://texample.net/tikz/examples/tag/plots/),
  sur [Texample.net](https://texample.net/)
:::