# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core import AsyncPipelineClient
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin
from msrest import Deserializer, Serializer

from ._configuration import VnetClientConfiguration

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implementation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class VnetClient(MultiApiClientMixin, _SDKClient):
    """VnetClient.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param endpoint: The workspace development endpoint, for example https://myworkspace.dev.azuresynapse.net.
    :type endpoint: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    """

    DEFAULT_API_VERSION = '2020-12-01'
    _PROFILE_TAG = "azure.synapse.managedprivateendpoints.VnetClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        endpoint: str,
        api_version: Optional[str] = DEFAULT_API_VERSION,
        profile: KnownProfiles = KnownProfiles.default,
        **kwargs  # type: Any
    ) -> None:
        if api_version == '2020-12-01' or api_version == '2021-06-01-preview':
            base_url = '{endpoint}'
        else:
            raise ValueError("API version {} is not available".format(api_version))
        self._config = VnetClientConfiguration(credential, endpoint, **kwargs)
        self._client = AsyncPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(VnetClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2020-12-01: :mod:`v2020_12_01.models<azure.synapse.managedprivateendpoints.v2020_12_01.models>`
           * 2021-06-01-preview: :mod:`v2021_06_01_preview.models<azure.synapse.managedprivateendpoints.v2021_06_01_preview.models>`
        """
        if api_version == '2020-12-01':
            from ..v2020_12_01 import models
            return models
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def managed_private_endpoints(self):
        """Instance depends on the API version:

           * 2020-12-01: :class:`ManagedPrivateEndpointsOperations<azure.synapse.managedprivateendpoints.v2020_12_01.aio.operations.ManagedPrivateEndpointsOperations>`
           * 2021-06-01-preview: :class:`ManagedPrivateEndpointsOperations<azure.synapse.managedprivateendpoints.v2021_06_01_preview.aio.operations.ManagedPrivateEndpointsOperations>`
        """
        api_version = self._get_api_version('managed_private_endpoints')
        if api_version == '2020-12-01':
            from ..v2020_12_01.aio.operations import ManagedPrivateEndpointsOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ManagedPrivateEndpointsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'managed_private_endpoints'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    async def close(self):
        await self._client.close()
    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
